function Fval = elastica_system_small_deflections(t, U, U_prev, dt, params)
    m = params.m;
    B = params.B;
    g = params.g;
    ze = params.ze;
    mu = params.mu;
    ref_t  = params.ref_t;
    ref_tt = params.ref_tt;

    alpha = 0;

    x  = U(1);
    y  = U(2);
    vx = U(3);
    vy = U(4);
    el = U(5);
    th = U(6);
    vl = U(7);

    x_prev  = U_prev(1);
    y_prev  = U_prev(2);
    vx_prev = U_prev(3);
    vy_prev = U_prev(4);
    el_prev = U_prev(5);
    th_prev = U_prev(6);
    % be_prev = U_prev(7);
    vl_prev = U_prev(7);

    t_prev = t-dt;

    c = 2*ze*sqrt(3*m*B/el^3);
    c_prev = 2*ze*sqrt(3*m*B/el_prev^3);
    disip_x = c/m*(ref_t(t)+vx);
    disip_y = c/m*(vy);
    disip_x_prev = c_prev/m*(ref_t(t_prev)+vx_prev);
    disip_y_prev = c_prev/m*(vy_prev);


    Mom = 2*B*th/el;
    Mom_prev = 2*B*th_prev/el_prev;

    Nx = 3*B/el^3*x;
    % Ny = Mom^2/2/B + mu*abs_Nx*sign_eldot;

    Nx_prev = 3*B/el_prev^3*x_prev;
    % Ny_prev = Mom_prev^2/2/B;

    epsilon_sign = 1e-3;
    sign_eldot = vl/sqrt(vl^2+epsilon_sign^2);
    abs_Nx = sqrt(Nx^2+epsilon_sign^2); % abs(Nx);%
    sign_eldot_prev = vl_prev/sqrt(vl_prev^2+epsilon_sign^2);
    abs_Nx_prev = sqrt(Nx_prev^2+epsilon_sign^2); % abs(Nx);%

    f1 = - g*sin(-alpha) - ref_tt(t) - disip_x - 3*B/el^3*x/m;
    f2 = - g*cos(-alpha) - disip_y + (Mom^2/2/B - mu*abs_Nx*sign_eldot)/m;

    f1_prev = - g*sin(-alpha) - ref_tt(t_prev) - disip_x_prev - 3*B/el_prev^3*x_prev/m;
    f2_prev = - g*cos(-alpha) - disip_y_prev + (Mom_prev^2/2/B - mu*abs_Nx_prev*sign_eldot_prev)/m;


    Fval(1) = vx - vx_prev - 0.5*dt*( f1 + f1_prev );
    Fval(2) = vy - vy_prev - 0.5*dt*( f2 + f2_prev );
    Fval(3) = dt*(x - 2/3*el*th);
    Fval(4) = dt*(y - el*( 1-4/15*th^2 ));
    % Fval(5) = dt*(Ny + (Ny*x-Nx*y)^2/2/B - mu*abs_Nx*sign_eldot);
    Fval(5) = x - x_prev - 0.5*dt*(vx+vx_prev);
    Fval(6) = y - y_prev - 0.5*dt*(vy+vy_prev);
    Fval(7) = el - el_prev - 0.5*dt*(vl+vl_prev);

    Fval = real(Fval);
end
